//
//  OfflineOTPViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class OfflineOTPViewController: BaseViewController {

    @IBOutlet weak var pinField: UITextField!

    @IBOutlet weak var resultContainerView: UIView!
    @IBOutlet weak var otpTextView: UILabel!
    @IBOutlet weak var countdownTextView: UILabel!
    
    var countdown: TimeInterval? = nil
    var countdownTimer: Timer? = nil

    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Offline OTP"
        self.pinField.isHidden = true
        self.resultContainerView.isHidden = true
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        checkSynchronization()
    }
    
    func checkSynchronization() {
        if InweboService.sharedInstance.otpShouldSynchronize() {
            self.showAlert(title: "Synchronization required", message: "Your application seems de-synchronized. Do you want to force synchronization ?",
                           button1: (name: "Synchronize", action: { _ in
                self.performSegue(withIdentifier: "pushToSynchronize", sender: self)
            }),
                           button2: (name: "Generate OTP", action: { _ in
                self.setupUi()
            }))
        } else {
            setupUi()
        }
    }
    
    func setupUi() {
        self.pinField.isHidden = !InweboService.sharedInstance.isOfflineOtpPinRequired()
    }
    
    func generateOtp() {
        let pin = self.pinField.text ?? ""
        let otp = InweboService.sharedInstance.getOfflineOtpGenerate(pin: pin)
        
        otpTextView.text = otp
        resultContainerView.isHidden = false
        
        self.countdown = InweboService.sharedInstance.countdown()
        self.countdownTextView.text = "OTP will expire in \(Int(countdown!))s"
        self.countdown! -= 1
        self.countdownTimer = Timer.scheduledTimer(withTimeInterval: 1, repeats: true, block: { timer in
            if let countdown = self.countdown {
                self.countdownTextView.text = "OTP will expire in \(Int(countdown))s"
                self.countdown! -= 1
                if countdown <= 0 {
                    timer.invalidate()
                    self.countdownTextView.text = "OTP is expired"
                }
            } else {
                timer.invalidate()
            }
        })
    }
    
    @IBAction func generateTouched(_ sender: Any) {
        generateOtp()
    }
    
    @IBAction func copyTouched(_ sender: Any) {
        UIPasteboard.general.string = otpTextView.text
    }
}
